<?php

use App\Http\Controllers\AgendaController;
use App\Http\Controllers\AlbumBillingualController;
use App\Http\Controllers\AlbumController;
use App\Http\Controllers\CategoryAgendaController;
use App\Http\Controllers\DivisionBillingualController;
use App\Http\Controllers\CategoryDocumentController;
use App\Http\Controllers\DocumentController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\MessageVisitorController;
use App\Http\Controllers\PageBillingualController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\PhotoBillingualController;
use App\Http\Controllers\PhotoController;
use App\Http\Controllers\PostBillingualController;
use App\Http\Controllers\PostController;
use App\Http\Controllers\ProductBillingualController;
use App\Http\Controllers\SearchController;
use App\Http\Controllers\TeamBillingualController;
use App\Http\Controllers\SliderController;
use App\Http\Controllers\SliderBillingualController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('login', [LoginController::class, 'login']);

//slider
Route::get('getAllSlider', [SliderController::class, 'getAllData']);
Route::get('getAllSliderWithPaginate', [SliderController::class, 'getAllDataWithPagination']);

//post
Route::get('selectPostThreeLatest', [PostController::class, 'selectThreeDatalatest']);
Route::post('selectPostBySlug', [PostController::class, 'selectDataBySlug']);
Route::post('selectPostByType', [PostController::class, 'selectDataByType']);
Route::get('selectPostByTypeWithPagination', [PostController::class, 'selectDataByTypeWithPagination']);

//category agenda
Route::get('getAllCategoryAgenda', [CategoryAgendaController::class, 'getAllData']);
Route::get('getAllCategoryAgendaWithPagination', [CategoryAgendaController::class, 'getAllDataWithPagination']);

//agenda
Route::get('selectAgendaThreeLatest', [AgendaController::class, 'selectThreeDataLatest']);
Route::get('getAllDataAgendaWithPagination', [AgendaController::class, 'getAllDataWithPagination']);
Route::post('selectAgendaBySlug', [AgendaController::class, 'selectDataBySlug']);

//page
Route::get('getAllPage', [PageController::class, 'getAllData']);
Route::post('selectPageBySlug', [PageController::class, 'selectDataBySlug']);
Route::post('selectPageBySlug', [PageController::class, 'selectDataBySlug']);

//album
Route::get('getAllAlbum', [AlbumController::class, 'getAllData']);
Route::post('selectAlbumBySlug', [AlbumController::class, 'selectDataBySlug']);

//category document
Route::get('getAllCategoryDocument', [CategoryDocumentController::class, 'getAllData']);
Route::get('getAllCategoryDocumentWithPagination', [CategoryDocumentController::class, 'getAllDataWithPagination']);

//document
Route::get('getAllDataDocumentWithPagination', [DocumentController::class, 'getAllDataWithPagination']);

Route::middleware('auth:sanctum')->group(function() {
    Route::post('logout', [LoginController::class, 'logout']);

    //post
    Route::post('selectPostById', [PostController::class, 'selectDataById']);
    Route::post('storePost', [PostController::class, 'storeData']);
    Route::post('updatePost', [PostController::class, 'updateData']);
    Route::post('deletePost', [PostController::class, 'deleteData']);
    Route::post('selectPostBillingualByType', [PostBillingualController::class, 'selectDataByType']);
    Route::post('selectPostBillingualByTypeWithPagination', [PostBillingualController::class, 'selectDataByTypeWithPagination']);
    Route::post('selectPostBillingualBySlug', [PostBillingualController::class, 'selectDataBySlug']);
    Route::post('selectPostBillingualById', [PostBillingualController::class, 'selectDataById']);
    Route::post('selectPostBillingualByTypeAndLimit', [PostBillingualController::class, 'selectDataByLimitAndType']);
    Route::post('storePostBillingual', [PostBillingualController::class, 'storeData']);
    Route::post('updatePostBillingual', [PostBillingualController::class, 'updateData']);
    Route::post('deletePostBillingual', [PostBillingualController::class, 'deleteData']);

    //category agenda
    Route::post('selectCategoryAgendaById', [CategoryAgendaController::class, 'selectDataById']);
    Route::post('storeCategoryAgenda', [CategoryAgendaController::class, 'storeData']);
    Route::post('updateCategoryAgenda', [CategoryAgendaController::class, 'updateData']);
    Route::post('deleteCategoryAgenda', [CategoryAgendaController::class, 'deleteData']);

    //agenda
    Route::get('getAllAgenda', [AgendaController::class, 'getAllData']);
    Route::post('selectAgendaById', [AgendaController::class, 'selectDataById']);
    Route::post('storeAgenda', [AgendaController::class, 'storeData']);
    Route::post('updateAgenda', [AgendaController::class, 'updateData']);
    Route::post('deleteAgenda', [AgendaController::class, 'deleteData']);

    //page
    Route::post('selectPageById', [PageController::class, 'selectDataById']);
    Route::post('storePage', [PageController::class, 'storeData']);
    Route::post('updatePage', [PageController::class, 'updateData']);
    Route::get('getAllPageBillingual', [PageBillingualController::class, 'getAllData']);
    Route::post('selectPageBillingualById', [PageBillingualController::class, 'selectDataById']);
    Route::post('selectPageBillingualBySlug', [PageBillingualController::class, 'selectDataBySlug']);
    Route::post('updatePageBillingual', [PageBillingualController::class, 'updateData']);

    //album
    Route::post('selectAlbumByid', [AlbumController::class, 'selectDataById']);
    Route::post('storeAlbum', [AlbumController::class, 'storeData']);
    Route::post('updateAlbum', [AlbumController::class, 'updateData']);
    Route::post('deleteAlbum', [AlbumController::class, 'deleteData']);

    //photo
    Route::post('selectPhotoById', [PhotoController::class, 'selectDataById']);
    Route::post('selectPhotoByAlbum', [PhotoController::class, 'selectDataByAlbum']);
    Route::post('storePhoto', [PhotoController::class, 'storeData']);
    Route::post('updatePhoto', [PhotoController::class, 'updateData']);
    Route::post('deletePhoto', [PhotoController::class, 'deleteData']);
    Route::post('selectPhotoBillingualByAlbum', [PhotoBillingualController::class, 'selectDataByAlbum']);
    Route::post('selectPhotoBillingualById', [PhotoBillingualController::class, 'selectDataById']);
    Route::post('storePhotoBillingual', [PhotoBillingualController::class, 'storeData']);
    Route::post('updatePhotoBillingual', [PhotoBillingualController::class, 'updateData']);
    Route::post('deletePhotoBillingual', [PhotoBillingualController::class, 'deleteData']);

    //album
    Route::get('getAllAlbumBillingual', [AlbumBillingualController::class, 'getAllData']);
    Route::post('getAllAlbumBillingualWithPagination', [AlbumBillingualController::class, 'getAllDataWithPagination']);
    Route::post('selectAlbumBillingualByid', [AlbumBillingualController::class, 'selectDataById']);
    Route::post('storeAlbumBillingual', [AlbumBillingualController::class, 'storeData']);
    Route::post('updateAlbumBillingual', [AlbumBillingualController::class, 'updateData']);

    //category document
    Route::post('selectCategoryDocumentById', [CategoryDocumentController::class, 'selectDataById']);
    Route::post('storeCategoryDocument', [CategoryDocumentController::class, 'storeData']);
    Route::post('updateCategoryDocument', [CategoryDocumentController::class, 'updateData']);
    Route::post('deleteCategoryDocument', [CategoryDocumentController::class, 'deleteData']);

    //document
    Route::get('getAllDocument', [AgendaController::class, 'getAllData']);
    Route::post('selectDocumentById', [DocumentController::class, 'selectDataById']);
    Route::post('storeDocument', [DocumentController::class, 'storeData']);
    Route::post('updateDocument', [DocumentController::class, 'updateData']);
    Route::post('deleteDocument', [DocumentController::class, 'deleteData']);

    //division
    Route::get('getAllDivisionBillingual', [DivisionBillingualController::class, 'getAllData']);
    Route::post('selectDivisionBillingualById', [DivisionBillingualController::class, 'selectDataById']);
    Route::post('storeDivisionBillingual', [DivisionBillingualController::class, 'storeData']);
    Route::post('updateDivisionBillingual', [DivisionBillingualController::class, 'updateData']);
    Route::post('updateDivisionBillingualOrder', [DivisionBillingualController::class, 'updateOrder']);
    Route::post('deleteDivisionBillingual', [DivisionBillingualController::class, 'deleteData']);
    Route::get('getAllTeamBillingual', [TeamBillingualController::class, 'getAlldata']);
    Route::post('getAllTeamBillingualWithPagination', [TeamBillingualController::class, 'getAllDataWithPagination']);

    //team
    Route::get('getAllTeamBillingualGroupByDivision', [TeamBillingualController::class, 'getAllDataGroupByDivision']);
    Route::post('selectTeamBillingualById', [TeamBillingualController::class, 'selectDataById']);
    Route::post('selectTeamBillingualBySlug', [TeamBillingualController::class, 'selectDataBySlug']);
    Route::post('selectTeamBillingualByDivision', [TeamBillingualController::class, 'selectDataByDivision']);
    Route::post('storeTeamBillingual', [TeamBillingualController::class, 'storeData']);
    Route::post('updateTeamBillingual', [TeamBillingualController::class, 'updateData']);
    Route::post('deleteTeamBillingaul', [TeamBillingualController::class, 'deleteData']);

    //product
    Route::get('getAllProductBillingual', [ProductBillingualController::class, 'getAllData']);
    Route::post('getAllProductBillingualWithPagination', [ProductBillingualController::class, 'getAllDataWithPagination']);
    Route::post('selectProductBillingualById', [ProductBillingualController::class, 'selectDataById']);
    Route::post('selectProductBillingualBySlug', [ProductBillingualController::class, 'selectDataBySlug']);
    Route::get('selectProductBillingualByFirstAndHighlight', [ProductBillingualController::class, 'selectDataByFirstAndHighlight']);
    Route::post('storeProductBillingual', [ProductBillingualController::class, 'storeData']);
    Route::post('updateProductBillingual', [ProductBillingualController::class, 'updateData']);
    Route::post('updateHighlightProductBillingual', [ProductBillingualController::class, 'updateDataHighlight']);
    Route::post('updateFirstProductBillingual', [ProductBillingualController::class, 'updateDataFirst']);
    Route::post('deleteProductBillingual', [ProductBillingualController::class, 'deleteData']);

    //slider
    Route::post('selectSliderById', [SliderController::class, 'selectDataById']);
    Route::get('selectSliderThreeLatest', [SliderController::class, 'selectThreeDataLatest']);
    Route::post('storeSlider', [SliderController::class, 'storeData']);
    Route::post('updateSlider', [SliderController::class, 'updateData']);
    Route::post('deleteSlider', [SliderController::class, 'deleteData']);

    //slider billingual
    Route::get('getAllSliderBillingual', [SliderBillingualController::class, 'getAllData']);
    Route::post('getAllSliderBillingualWithPagination', [SliderBillingualController::class, 'getAllDataWithPagination']);
    Route::post('selectSliderBillingualById', [SliderBillingualController::class, 'selectDataById']);
    Route::post('selectSliderBillingualByHighlight', [SliderBillingualController::class, 'selectDataByHighlight']);
    Route::post('storeSliderBillingual', [SliderBillingualController::class, 'storeData']);
    Route::post('updateSliderBillingual', [SliderBillingualController::class, 'updateData']);
    Route::post('updateFirstSliderBillingual', [SliderBillingualController::class, 'updateDataFirst']);
    Route::post('deleteSliderBillingual', [SliderBillingualController::class, 'deleteData']);

    //message visitor
    Route::get('getAllMessageVisitor', [MessageVisitorController::class, 'getAllData']);
    Route::post('getAllMessageVisitorWithPagination', [MessageVisitorController::class, 'getAllDataWithPagination']);
    Route::post('selectMessageVisitorByid', [MessageVisitorController::class, 'selectDataById']);
    Route::post('storeMessageVisitor', [MessageVisitorController::class, 'storeData']);
    Route::post('deleteMessageVisitor', [MessageVisitorController::class, 'deleteData']);
    Route::post('getDataSearch', [SearchController::class, 'getDataSearch']);
});
