<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use Laravel\Sanctum\NewAccessToken;

class TokenController extends Controller
{
    //create token
    public function createToken(Request $request, array $abilities = ['*']) {
        $plainTextToken = Str::random(40);

        $token = $this->tokens()->create([
            'name' => $request->name,
            'token' => Hash::make($plainTextToken),
            'abilities' => $abilities,
        ]);

        $accessToken = new NewAccessToken($token, $token->getKey().'|'.$plainTextToken);

        return response()->json([
            'status' => true,
            'message' => 'token berhasil dibuat',
            'token' => $accessToken
        ], 200);
    }
}
