<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Pagination\LengthAwarePaginator;
use App\Models\Team;
use App\Models\TeamBillingual;
use App\Models\Division;
use App\Models\DivisionBillingual;
use Image;

class TeamBillingualController extends Controller
{
    //get all data
    public function getAllData() {
        $dataArray = array();
        $queryDataTeam = Team::orderByDesc('id');
        $dataTeams = $queryDataTeam->get();
        $countDataTeam = $queryDataTeam->count();

        foreach($dataTeams as $dataTeam) {
            $dataTeamBillingual = TeamBillingual::where('id_team', $dataTeam->id)->first();
            $dataDivision = Division::where('id', $dataTeam->id_division)->first();
            $dataDivisionBilingual = DivisionBillingual::where('id_division', $dataDivision->id)->first();
            array_push($dataArray, (object)[
                'team' => $dataTeam,
                'teamBillingual' => $dataTeamBillingual,
                'division' => $dataDivision,
                'divisionBilingual' => $dataDivisionBilingual
            ]);
        } 

        return response()->json([
            'status' => true,
            'message' => 'Data tim berhasil didapatkan',
            'totalData' => $countDataTeam,
            'data' => $dataArray
        ], 200);
    }

    //geta all data with pagination
    public function getAllDataWithPagination(Request $request) {
        $dataArray = array();
        $queryDataTeams = Team::orderByDesc('id');
        $dataTeams = $queryDataTeams->get();
        $totalDataTeam = $queryDataTeams->count();

        foreach($dataTeams as $dataTeam) {
            $dataTeamBillingual = TeamBillingual::where('id_team', $dataTeam->id)->first();
            $dataDivision = Division::where('id', $dataTeam->id_division)->first();
            $dataDivisionBilingual = DivisionBillingual::where('id_division', $dataDivision->id)->first();
            array_push($dataArray, (object)[
                'team' => $dataTeam,
                'teamBillingual' => $dataTeamBillingual,
                'division' => $dataDivision,
                'divisionBilingual' => $dataDivisionBilingual
            ]);
        }

        $perPage = 20;
        $currentPage = $request->currentPage;
        $offset = ($currentPage * $perPage) - $perPage;
        $dataToShow = array_slice($dataArray, $offset, $perPage);
        
        $dataArrayPaginate = new LengthAwarePaginator($dataToShow, $totalDataTeam, $perPage);

        return response()->json([
            'status' => true,
            'data' => $dataArrayPaginate
        ], 200);
    }

    //get all data group by division
    public function getAllDataGroupByDivision() {
        $dataArray = array();
        $dataDivisions = Division::orderBy('highlight', 'ASC')->get();

        foreach($dataDivisions as $dataDivision) {
            $subDataArray = array();
            $dataTeams = Team::where('id_division', $dataDivision->id)->get();
            $dataDivisionBilingual = DivisionBillingual::where('id_division', $dataDivision->id)->first();

            foreach($dataTeams as $dataTeam) {
                $dataTeamBillingual = TeamBillingual::where('id_team', $dataTeam->id)->first();
                array_push($subDataArray, (object) [
                    'team' => $dataTeam,
                    'teamBillingual' => $dataTeamBillingual
                ]);
            }

            array_push($dataArray, (object) [
                'divisi' => $dataDivision,
                'divisiBillingual' => $dataDivisionBilingual,
                'teams' => $subDataArray
            ]);
        }
        
        return response()->json([
            'status' => true,
            'message' => 'Data tim berhasil didapatkan',
            'data' => $dataArray
        ], 200);
    }

    //select data by id
    public function selectDataById(Request $request) {
        $dataArray = array();
        $dataTeam = Team::where('id', $request->id)->first();
        $dataTeamBillingual = TeamBillingual::where('id_team', $dataTeam->id)->first();
        $dataDivision = Division::where('id', $dataTeam->id_division)->first();
        $dataDivisionBilingual = DivisionBillingual::where('id_division', $dataDivision->id)->first();

        array_push($dataArray, (object)[
            'team' => $dataTeam,
            'teamBillingual' => $dataTeamBillingual,
            'division' => $dataDivision,
            'divisionBilingual' => $dataDivisionBilingual
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Data tim berhasil didapatkan',
            'data' => $dataArray
        ], 200);
    }

    //select data by slug
    public function selectDataBySlug(Request $request) {
        $dataArray = array();
        $dataTeam = Team::where('slug', $request->slug)->first();
        $dataTeamBillingual = TeamBillingual::where('id_team', $dataTeam->id)->first();
        $dataDivision = Division::where('id', $dataTeam->id_division)->first();
        $dataDivisionBilingual = DivisionBillingual::where('id_division', $dataDivision->id)->first();

        array_push($dataArray, (object)[
            'team' => $dataTeam,
            'teamBillingual' => $dataTeamBillingual,
            'division' => $dataDivision,
            'divisionBilingual' => $dataDivisionBilingual
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Data tim berhasil didapatkan',
            'data' => $dataArray
        ], 200);
    }

    //select data by division
    public function selectDataByDivision(Request $request) {
        $dataArray = array();
        $dataDivisions = Division::where('id', $request->id)->get();

        foreach($dataDivisions as $dataDivision) {
            $subDataArray = array();
            $dataTeams = Team::where('id_division', $dataDivision->id)->get();
            $dataDivisionBilingual = DivisionBillingual::where('id_division', $dataDivision->id)->first();

            foreach($dataTeams as $dataTeam) {
                $dataTeamBillingual = TeamBillingual::where('id_team', $dataTeam->id)->first();
                array_push($subDataArray, (object) [
                    'team' => $dataTeam,
                    'teamBillingual' => $dataTeamBillingual
                ]);
            }

            array_push($dataArray, (object) [
                'divisi' => $dataDivision,
                'divisiBillingual' => $dataDivisionBilingual,
                'teams' => $subDataArray
            ]);
        }
        
        return response()->json([
            'status' => true,
            'message' => 'Data tim berhasil didapatkan',
            'data' => $dataArray
        ], 200);
    }

    //store data
    public function storeData(Request $request) {
        $validateImage = $this->validate($request, [
            'image' => 'required|image|mimes:jpg,png,jpeg|max:1024',
        ]);

        $image = $request->file('image');
        $imageName = time().'.'.$image->extension();
        $path = public_path('/storage/team');
        $img = Image::make($image->path());
        $thumbImage = $img->resize(400, 400, function($constraint) {
            $constraint->aspectRatio();
        })->save($path.'/'.$imageName);

        $storeTeam = Team::create([
            'name' => $request->name,
            'slug' => $request->slug,
            'position' => $request->position,
            'biography' => $request->biography,
            'fb' => $request->fb,
            'tw' => $request->tw,
            'ig' => $request->ig,
            'in' => $request->li,
            'photo' => $imageName,
            'id_division' => $request->idDivision
        ]);

        TeamBillingual::create([
            'position' => $request->positionBilingual,
            'biography' => $request->biographyBilingual,
            'id_team' => $storeTeam->id
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Data tim berhasil disimpan'
        ], 200);
    }

    //update data
    public function updateData(Request $request) {
        $data = Team::where('id', $request->id)->first();

        if($request->hasFile('image')) {
            $validateImage = $this->validate($request, [
                'image' => 'required|image|mimes:jpg,png,jpeg|max:1024',
            ]);
    
            $image = $request->file('image');
            $imageName = time().'.'.$image->extension();
            $path = public_path('/storage/team');
            $img = Image::make($image->path());
            $thumbImage = $img->resize(600, 600, function($constraint) {
                $constraint->aspectRatio();
            })->save($path.'/'.$imageName);

            File::delete($path.'/'.$data->photo);
        } else {
            $imageName = $data->photo;
        }

        Team::where('id', $request->id)
            ->update([
                'name' => $request->name,
                'slug' => $request->slug,
                'position' => $request->position,
                'biography' => $request->biography,
                'fb' => $request->fb,
                'tw' => $request->tw,
                'ig' => $request->ig,
                'in' => $request->li,
                'photo' => $imageName,
                'id_division' => $request->idDivision
        ]);

        TeamBillingual::where('id_team', $request->id)
            ->update([
                'position' => $request->positionBilingual,
                'biography' => $request->biographyBilingual,
            ]);

        return response()->json([
            'status' => true,
            'message' => 'Data tim berhasil diupdate'
        ], 200);
    }

    //delete data
    public function deleteData(Request $request) {
        $data = Team::where('id', $request->id)->first();

        $path = public_path('/storage/team');
        File::delete($path.'/'.$data->photo);

        Team::where('id', $request->id)->delete();
        TeamBillingual::where('id', $request->id)->delete();

        return response()->json([
            'status' => true,
            'message' => 'Data tim berhasil dihapus'
        ], 200);
    }
}
