<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Slider;
use Illuminate\Support\Facades\File;
use Image;

class SliderController extends Controller
{
    //get all data
    public function getAllData() {
        $data = Slider::orderByDesc('id')->get();
        $totalData = Slider::count();

        return response()->json([
            'status' => true,
            'totalData' => $totalData,
            'data' => $data
        ], 200);
    }

    //get all data with pagination
    public function getAllDataWithPagination() {
        $data = Slider::orderByDesc('id')->paginate(50);
        $totalData = Slider::count();

        return response()->json([
            'status' => true,
            'totalData' => $totalData,
            'data' => $data
        ], 200);
    }

    //select latest 3 slider
    public function selectThreeDataLatest() {
        $data = Slider::orderByDesc('id')->limit(3)->get();

        return response()->json([
            'status' => true,
            'message' => 'Data slider berhasil didapatkan',
            'data' => $data
        ], 200);
    }

    //select data by id
    public function selectDataById(Request $request) {
        $data = Slider::where('id', $request->id)->get();

        return response()->json([
            'status' => true,
            'message' => 'Data slider berhasil didapatkan',
            'data' => $data
        ], 200);
    }

    //store data
    public function storeData(Request $request) {
        if($request->hasFile('image')){
            $validateImage = $this->validate($request, [
                'image' => 'required|image|mimes:jpg,png,jpeg,webp|max:2048',
            ], [
                'image.image' => 'File haru berupa gambar',
                'image.mimes' => 'File Gambar harus bertipe jpg, png, jpeg, atau webp',
                'image.max' => 'File gambar yang di upload maksimal 2 MB'
            ]);

            $image = $request->file('image');
            $imageName = time().'.'.$image->extension();
            $thumbPath = public_path('/storage/slider/thumb_images');
            $destinationPath = public_path('/storage/slider/images');
            $img = Image::make($image->path());
            $thumbImage = $img->resize(700, 700, function($constraint) {
                $constraint->aspectRatio();
            })->save($thumbPath.'/thumb_'.$imageName);
            $mainImage = $image->move($destinationPath, $imageName);
        }else{
            $imageName = 'no-image';
        }

        $storeSlider = Slider::create([
            'title' => $request->title,
            'caption' => '',
            'name_link' => '',
            'link' => '',
            'highlight' => 1,
            'thumb_image' => 'thumb_'.$imageName,
            'image' => $imageName
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Data slider behasil disimpan'
        ], 200);
    }

    //update data
    public function updateData(Request $request) {
        $data = Slider::where('id', $request->id)->first();

        if($request->hasFile('image')){
            $validateImage = $this->validate($request, [
                'image' => 'required|image|mimes:jpg,png,jpeg,webp|max:2048',
            ], [
                'image.image' => 'File haru berupa gambar',
                'image.mimes' => 'File Gambar harus bertipe jpg, png, jpeg, atau webp',
                'image.max' => 'File gambar yang di upload maksimal 2 MB'
            ]);

            $image = $request->file('image');
            $imageName = time().'.'.$image->extension();
            $thumbPath = public_path('/storage/slider/thumb_images');
            $destinationPath = public_path('/storage/slider/images');
            $img = Image::make($image->path());

            $thumbImage = $img->resize(700, 700, function($constraint) {
                $constraint->aspectRatio();
            })->save($thumbPath.'/thumb_'.$imageName);

            $mainImage = $image->move($destinationPath, $imageName);

            File::delete($thumbPath.'/'.$data->thumb_image);
            File::delete($destinationPath.'/'.$data->image);
        }else{
            $imageName = $data->image;
        }

        if ($request->title) {
            $title = $request->title;
        } else {
            $title = '';
        }

        Slider::where('id', $request->id)->update([
            'title' => $title,
            'thumb_image' => 'thumb_'.$imageName,
            'image' => $imageName
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Data slider behasil diupdate'
        ], 200);
    }

    //delete data
    public function deleteData(Request $request) {
        $dataSlider = Slider::where('id', $request->id)->first();

        $pathThumbImage = public_path('/storage/slider/thumb_images');
        $pathImage = public_path('/storage/slider/images');
        File::delete($pathThumbImage.'/'.$dataSlider->thumb_image);
        File::delete($pathImage.'/'.$dataSlider->image);

        Slider::where('id', $request->id)->delete();

        return response()->json([
            'status' => true,
            'message' => 'Data slider berhasil dihapus'
        ], 200);
    }
}
