<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Pagination\LengthAwarePaginator;
use App\Models\Slider;
use App\Models\SliderBillingual;
use Image;

class SliderBillingualController extends Controller
{
    //get all data
    public function getAllData() {
        $dataArray = array();
        $dataSliders = Slider::orderByDesc('id')->get();
        $countDataSlider = Slider::count();

        foreach($dataSliders as $dataSlider) {
            $dataSliderBillingual = SliderBillingual::where('id_slider', $dataSlider->id)->first();
            array_push($dataArray, (object) [
                'slider' => $dataSlider,
                'sliderBillingual' => $dataSliderBillingual
            ]);
        }

        return response()->json([
            'status' => true,
            'message' => 'Data slider berhasil didapatkan',
            'totalData' => $countDataSlider,
            'data' => $dataArray
        ], 200);
    }

    //get all data with pagination
    public function getAllDataWithPagination(Request $request) {
        $dataArray = array();
        $queryDataSliders = Slider::orderByDesc('id');
        $dataSliders = $queryDataSliders->get();
        $totalDataSlider = $queryDataSliders->count();

        foreach($dataSliders as $dataSlider) {
            $dataSliderBillingual = SliderBillingual::where('id_slider', $dataSlider->id)->first();
            array_push($dataArray, (object)[
                'slider' => $dataSlider,
                'sliderBillingual' => $dataSliderBillingual
            ]);
        }

        $perPage = 20;
        $currentPage = $request->currentPage;
        $offset = ($currentPage * $perPage) - $perPage;
        $dataToShow = array_slice($dataArray, $offset, $perPage);
        
        $dataArrayPaginate = new LengthAwarePaginator($dataToShow, $totalDataSlider, $perPage);

        return response()->json([
            'status' => true,
            'data' => $dataArrayPaginate
        ], 200);
    }

    //select data by id
    public function selectDataById(Request $request) {
        $dataArray = array();
        $dataSlider = Slider::where('id', $request->id)->first();
        $dataSliderBillingual = SliderBillingual::where('id_slider', $request->id)->first();

        array_push($dataArray, (object) [
            'slider' => $dataSlider,
            'sliderBillingual' => $dataSliderBillingual
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Data slider berhasil didapatkan',
            'data' => $dataArray
        ], 200);
    }

    //select data by highlight
    public function selectDataByHighlight(Request $request) {
        $dataArray = array();
        $dataSliders = Slider::where('highlight', $request->highlight)->orderByDesc('id')->get();

        foreach($dataSliders as $dataSlider) {
            $dataSliderBillingual = SliderBillingual::where('id_slider', $dataSlider->id)->first();
            array_push($dataArray, (object) [
                'slider' => $dataSlider,
                'sliderBillingual' => $dataSliderBillingual
            ]);
        }

        return response()->json([
            'status' => true,
            'message' => 'Data slider berhasil didapatkan',
            'data' => $dataArray
        ], 200);
    }

    //store data
    public function storeData(Request $request) {
        if($request->hasFile('image')){
            $validateImage = $this->validate($request, [
                'image' => 'required|image|mimes:jpg,png,jpeg|max:1048',
            ]);

            $image = $request->file('image');
            $imageName = time().'.'.$image->extension();
            $thumbPath = public_path('/storage/slider/thumb_images');
            $destinationPath = public_path('/storage/slider/images');
            $img = Image::make($image->path());
            $thumbImage = $img->resize(600, 600, function($constraint) {
                $constraint->aspectRatio();
            })->save($thumbPath.'/thumb_'.$imageName);
            $mainImage = $image->move($destinationPath, $imageName);
        }else{
            $imageName = 'no-image';
        }

        $countDataProduct = Slider::count();

        if($countDataProduct == 0) {
            $highlight = 1;
        } else {
            $highlight = 0;
        }

        $storeSlider = Slider::create([
            'title' => $request->title,
            'caption' => $request->caption,
            'name_link' => $request->nameLink,
            'link' => $request->link,
            'highlight' => $highlight,
            'thumb_image' => 'thumb_'.$imageName,
            'image' => $imageName
        ]);

        SliderBillingual::create([
            'title' => $request->titleBilingual,
            'caption' => $request->captionBilingual,
            'name_link' => $request->nameLinkBilingual,
            'id_slider' => $storeSlider->id
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Data slider behasil disimpan'
        ], 200);
    }

    //update data
    public function updateData(Request $request) {
        $data = Slider::where('id', $request->id)->first();

        if($request->hasFile('image')){
            $validateImage = $this->validate($request, [
                'image' => 'required|image|mimes:jpg,png,jpeg|max:1048',
            ]);

            $image = $request->file('image');
            $imageName = time().'.'.$image->extension();
            $thumbPath = public_path('/storage/slider/thumb_images');
            $destinationPath = public_path('/storage/slider/images');
            $img = Image::make($image->path());

            $thumbImage = $img->resize(400, 400, function($constraint) {
                $constraint->aspectRatio();
            })->save($thumbPath.'/thumb_'.$imageName);

            $mainImage = $image->move($destinationPath, $imageName);

            File::delete($thumbPath.'/'.$data->thumb_image);
            File::delete($destinationPath.'/'.$data->image);
        }else{
            $imageName = $data->image;
        }

        Slider::where('id', $request->id)->update([
            'title' => $request->title,
            'caption' => $request->caption,
            'name_link' => $request->nameLink,
            'link' => $request->link,
            'thumb_image' => 'thumb_'.$imageName,
            'image' => $imageName
        ]);

        SliderBillingual::where('id_slider', $request->id)->update([
            'title' => $request->titleBilingual,
            'caption' => $request->captionBilingual,
            'name_link' => $request->nameLinkBilingual,
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Data slider behasil diupdate'
        ], 200);
    }

    //update first
    public function updateDataFirst(Request $request) {
        Slider::where('highlight', 1)->update([
            'highlight' => 0
        ]);

        Slider::where('id', $request->id)->update([
            'highlight' => 1
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Data slider behasil dijadikan urutan pertama',
        ], 200);
    }

    //delete data
    public function deleteData(Request $request) {
        $dataSlider = Slider::where('id', $request->id)->first();

        if($dataSlider->highlight == 1) {
            return response()->json([
                'status' => false,
                'message' => 'Data slider tidak bisa dihapus karena dalam keadaan dihighlight'
            ], 200);
        }

        $pathThumbImage = public_path('/storage/slider/thumb_images');
        $pathImage = public_path('/storage/slider/images');
        File::delete($pathThumbImage.'/'.$dataSlider->thumb_image);
        File::delete($pathImage.'/'.$dataSlider->image);

        Slider::where('id', $request->id)->delete();
        SliderBillingual::where('id_slider', $request->id)->delete();

        return response()->json([
            'status' => true,
            'message' => 'Data slider berhasil dihapus'
        ], 200);
    }
}
