<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\ProductBillingual;
use App\Models\Post;
use App\Models\PostBillingual;

class SearchController extends Controller
{
    //get data search
    public function getDataSearch(Request $request) {
        $dataArrayProduct = array();
        $dataArrayPost = array();
        if($request->lang == 'id') {
            $dataProducts = Product::where('name', 'LIKE', '%'.$request->textSearch.'%')->get();
            $dataPosts = Post::where('title', 'LIKE', '%'.$request->textSearch.'%')->get();

            foreach($dataProducts as $dataProduct) {
                $dataProductBillingual = ProductBillingual::where('id_product', $dataProduct->id)->first();
                array_push($dataArrayProduct, (object) [
                    'product' => $dataProduct,
                    'productBillingual' => $dataProductBillingual
                ]);
            }

            foreach($dataPosts as $dataPost) {
                $dataPostBillingual = PostBillingual::where('id_post', $dataPost->id)->first();
                array_push($dataArrayPost, (object) [
                    'post' => $dataPost,
                    'postBillingual' => $dataPostBillingual
                ]);
            }
        } else {
            $dataProductBillinguals = ProductBillingual::where('name', 'LIKE', '%'.$request->textSearch.'%')->get();
            $dataPostBillinguals = PostBillingual::where('title', 'LIKE', '%'.$request->textSearch.'%')->get();

            foreach($dataProductBillinguals as $dataProductBillingual) {
                $dataProduct = Product::where('id', $dataProductBillingual->id_product)->first();
                array_push($dataArrayProduct, (object) [
                    'product' => $dataProduct,
                    'productBillingual' => $dataProductBillingual
                ]);
            }

            foreach($dataPostBillinguals as $dataPostBillingual) {
                $dataPost = Post::where('id', $dataPostBillingual->id_post)->first();
                array_push($dataArrayPost, (object) [
                    'post' => $dataPost,
                    'postBillingual' => $dataPostBillingual
                ]);
            }
        }

        return response()->json([
            'status' => true,
            'dataProduct' => $dataArrayProduct,
            'dataPost' => $dataArrayPost
        ], 200);
    }
}
