<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Post;
use Illuminate\Support\Facades\File;
use Image;

class PostController extends Controller
{
    //get all data
    public function getAlldata() {
        $data = Post::orderByDesc('id')->get();
        $totalData = Post::count();
        
        return response()->json([
            'status' => true,
            'message' => 'Data post berhasil didapatkan',
            'totalData' => $totalData,
            'data' => $data
        ], 200);
    }

    // select data with pagination
    public function selectDataByTypeWithPagination(Request $request) {
        $search = $request->search;
        $year = $request->year;

        if($year) {
            $query = Post::where('type', $request->type)
                    ->where('title', 'LIKE', '%'.$search.'%')
                    ->where('year', '=', $year)
                    ->orderByDesc('id');
        } else {
            $query = Post::where('type', $request->type)
                    ->where('title', 'LIKE', '%'.$search.'%')
                    ->orderByDesc('id');
        }

        $data = $query->paginate(50);
        $totalData = $query->count();

        return response()->json([
            'status' => true,
            'message' => 'Data post berhasil didapatkan',
            'totalData' => $totalData,
            'data' => $data
        ], 200);
    }

    //get data by type
    public function selectDataByType(Request $request) {
        $query = Post::where('type', $request->type)->orderByDesc('id');
        $data = $query->get();
        $totalData = $query->count();

        return response()->json([
            'status' => true,
            'message' => 'Data post berhasil didapatkan',
            'totalData' => $totalData,
            'data' => $data
        ], 200);
    }

    //get data by id
    public function selectDataById(Request $request) {
        $data = Post::where('id', $request->id)->get();

        return response()->json([
            'status' => true,
            'message' => 'Data post berhasil didapatkan',
            'data' => $data
        ], 200);
    }

    // get data by slug
    public function selectDataBySlug(Request $request) {
        $data = Post::where('slug', $request->slug)->first();

        return response()->json([
            'status' => true,
            'message' => 'Data post berhasil didapatkan',
            'data' => $data
        ], 200);
    }

    //select 3 data latest 
    public function selectThreeDatalatest(Request $request) {
        $data = Post::where('type', $request->type)->orderByDesc('id')->limit(3)->get();

        return response()->json([
            'status' => true,
            'message' => 'Data post berhasil didapatkan',
            'data' => $data
        ], 200);
    }

    //store data
    public function storeData(Request $request) {
        if($request->hasFile('image')){
            $validateImage = $this->validate($request, [
                'image' => 'required|image|mimes:jpg,png,jpeg,webp|max:2048',
            ], [
                'image.image' => 'File haru berupa gambar',
                'image.mimes' => 'File Gambar harus bertipe jpg, png, jpeg, atau webp',
                'image.max' => 'File gambar yang di upload maksimal 2 MB'
            ]);

            $image = $request->file('image');
            $imageName = time().'.'.$image->extension();
            $thumbPath = public_path('/storage/post/thumb_images');
            $destinationPath = public_path('/storage/post/images');
            $img = Image::make($image->path());
            $thumbImage = $img->resize(500, 500, function($constraint) {
                $constraint->aspectRatio();
            })->save($thumbPath.'/thumb_'.$imageName);
            $mainImage = $image->move($destinationPath, $imageName);
        }else{
            $imageName = 'no-image';
        }

        if($request->hasFile('file')){
            $validateFile = $this->validate($request, [
                'file' => 'required|mimes:pdf',
            ]);

            $file = $request->file('file');
            $fileName = $request->file->getClientOriginalName();
            $destinationPath = public_path('/storage/document');
            $mainFile = $file->move($destinationPath, $fileName);
        }else{
            $fileName = '';
        }

        Post::create([
            'type' => $request->type,
            'title' => $request->title,
            'slug' => $request->slug,
            'text' => $request->text,
            'thumb_image' => 'thumb_'.$imageName,
            'image' => $imageName,
            'file' => $fileName
        ]);        

        return response()->json([
            'status' => true,
            'message' => 'Data post berhasil disimpan'
        ], 200);
    }

    //update data
    public function updateData(Request $request) {
        $data = Post::where('id', $request->id)->get();

        if($request->hasFile('image')){
            $validateImage = $this->validate($request, [
                'image' => 'required|image|mimes:jpg,png,jpeg,webp|max:2048',
            ], [
                'image.image' => 'File haru berupa gambar',
                'image.mimes' => 'File Gambar harus bertipe jpg, png, jpeg, atau webp',
                'image.max' => 'File gambar yang di upload maksimal 2 MB'
            ]);

            $image = $request->file('image');
            $imageName = time().'.'.$image->extension();
            $thumbPath = public_path('/storage/post/thumb_images');
            $destinationPath = public_path('/storage/post/images');
            $img = Image::make($image->path());

            $thumbImage = $img->resize(500, 500, function($constraint) {
                $constraint->aspectRatio();
            })->save($thumbPath.'/thumb_'.$imageName);

            $mainImage = $image->move($destinationPath, $imageName);

            File::delete($thumbPath.'/'.$data[0]->thumb_image);
            File::delete($destinationPath.'/'.$data[0]->image);
        }else{
            $imageName = $data[0]->image;
        }

        if($request->hasFile('file')){
            $validateFile = $this->validate($request, [
                'file' => 'mimes:pdf',
            ], [
                'file.mimes' => 'File harus berupa pdf',
            ]);

            $file = $request->file('file');
            $fileName = $request->file->getClientOriginalName();
            $destinationPath = public_path('/storage/document');
            $mainFile = $file->move($destinationPath, $fileName);
        }else{
            $fileName = $data[0]->file;
        }

        Post::where('id', $request->id)
            ->update([
                'type' => $request->type,
                'title' => $request->title,
                'slug' => $request->slug,
                'text' => $request->text,
                'thumb_image' => 'thumb_'.$imageName,
                'image' => $imageName,
                'file' => $fileName
            ]);

        return response()->json([
            'status' => true,
            'message' => 'Data Post berhasil diupdate'
        ], 200);
    }

    //delete data
    public function deleteData(Request $request) {
        $data = Post::where('id', $request->id)->get();

        $pathThumbImage = public_path('/storage/post/thumb_images');
        $pathImage = public_path('/storage/post/images');
        File::delete($pathThumbImage.'/'.$data[0]->thumb_image);
        File::delete($pathImage.'/'.$data[0]->image);

        Post::where('id', $request->id)->delete();

        return response()->json([
            'status' => true,
            'message' => 'Data post berhasil dihapus'
        ], 200);
    }
}
