<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Post;
use App\Models\PostBillingual;
use Illuminate\Support\Facades\File;
use Illuminate\Pagination\LengthAwarePaginator;
use Image;

class PostBillingualController extends Controller
{
    //select post by type
    public function selectDataByType(Request $request) {
        $dataArray = array();
        $queryDataPosts = Post::where('type', $request->type)->orderByDesc('id');
        $dataPosts = $queryDataPosts->get();
        $countDataPost = $queryDataPosts->count();

        foreach($dataPosts as $dataPost) {
            $dataPostBillingual = PostBillingual::where('id_post', $dataPost->id)->first();
            array_push($dataArray, (object)[
                'dataPost' => $dataPost,
                'dataPostBillingual' => $dataPostBillingual
            ]);
        } 

        return response()->json([
            'status' => true,
            'totalData' => $countDataPost,
            'data' => $dataArray
        ], 200);
    }

    //select post by type with pagination
    public function selectDataByTypeWithPagination(Request $request) {
        $dataArray = array();
        $queryDataPosts = Post::where('type', $request->type)->orderByDesc('id');
        $dataPosts = $queryDataPosts->get();
        $totalDataPost = $queryDataPosts->count();

        foreach($dataPosts as $dataPost) {
            $dataPostBillingual = PostBillingual::where('id_post', $dataPost->id)->first();
            array_push($dataArray, (object)[
                'dataPost' => $dataPost,
                'dataPostBillingual' => $dataPostBillingual
            ]);
        }

        $perPage = 20;
        $currentPage = $request->currentPage;
        $offset = ($currentPage * $perPage) - $perPage;
        $dataToShow = array_slice($dataArray, $offset, $perPage);
        
        $dataArrayPaginate = new LengthAwarePaginator($dataToShow, $totalDataPost, $perPage);

        return response()->json([
            'status' => true,
            'data' => $dataArrayPaginate
        ], 200);
    }

    //select post by slug
    public function selectDataBySlug(Request $request) {
        $dataArray = array();
        $dataPost = Post::where('slug', $request->slug)->first();
        $dataPostBillingual = PostBillingual::where('id_post', $dataPost->id)->first();

        array_push($dataArray, (object)[
            'dataPost' => $dataPost,
            'dataPostBillingual' => $dataPostBillingual
        ]);

        return response()->json([
            'status' => true,
            'data' => $dataArray
        ], 200);
    }

    //select post by type and limit
    public function selectDataByLimitAndType(Request $request) {
        $dataArray = array();
        $queryDataPosts = Post::where('type', $request->type)->orderByDesc('id')->limit($request->limit);
        $dataPosts = $queryDataPosts->get();

        foreach($dataPosts as $dataPost) {
            $dataPostBillingual = PostBillingual::where('id_post', $dataPost->id)->first();
            array_push($dataArray, (object)[
                'dataPost' => $dataPost,
                'dataPostBillingual' => $dataPostBillingual
            ]);
        } 

        return response()->json([
            'status' => true,
            'data' => $dataArray
        ], 200);
    }

    //select data by id
    public function selectDataById(Request $request) {
        $queryDataPosts = Post::where('id', $request->id);
        $dataPosts = $queryDataPosts->get();
        $countDataPost = $queryDataPosts->count();

        $dataArray = array();
        foreach($dataPosts as $dataPost) {
            $dataPostBillingual = PostBillingual::where('id_post', $dataPost->id)->first();
            array_push($dataArray, (object)[
                'dataPost' => $dataPost,
                'dataPostBillingual' => $dataPostBillingual
            ]);
        } 

        return response()->json([
            'status' => true,
            'totalData' => $countDataPost,
            'data' => $dataArray
        ], 200);
    }

    //store data
    public function storeData(Request $request) {
        if($request->hasFile('image')){
            $validateImage = $this->validate($request, [
                'image' => 'required|image|mimes:jpg,png,jpeg|max:1048',
            ]);

            $image = $request->file('image');
            $imageName = time().'.'.$image->extension();
            $thumbPath = public_path('/storage/post/thumb_images');
            $destinationPath = public_path('/storage/post/images');
            $img = Image::make($image->path());
            $thumbImage = $img->resize(600, 600, function($constraint) {
                $constraint->aspectRatio();
            })->save($thumbPath.'/thumb_'.$imageName);
            $mainImage = $image->move($destinationPath, $imageName);
        }else{
            $imageName = 'no-image';
        }

        $storePost = Post::create([
            'type' => $request->type,
            'title' => $request->title,
            'slug' => $request->slug,
            'text' => $request->text,
            'thumb_image' => 'thumb_'.$imageName,
            'image' => $imageName
        ]);   

        PostBillingual::create([
            'title' => $request->titleBilingual,
            'text' => $request->textBilingual,
            'id_post' => $storePost->id
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Data Post berhasil disimpan',
        ], 200);
    }

    //update data
    public function updateData(Request $request) {
        $data = Post::where('id', $request->id)->get();

        if($request->hasFile('image')){
            $validateImage = $this->validate($request, [
                'image' => 'required|image|mimes:jpg,png,jpeg|max:1048',
            ]);

            $image = $request->file('image');
            $imageName = time().'.'.$image->extension();
            $thumbPath = public_path('/storage/post/thumb_images');
            $destinationPath = public_path('/storage/post/images');
            $img = Image::make($image->path());

            $thumbImage = $img->resize(600, 600, function($constraint) {
                $constraint->aspectRatio();
            })->save($thumbPath.'/thumb_'.$imageName);

            $mainImage = $image->move($destinationPath, $imageName);

            File::delete($thumbPath.'/'.$data[0]->thumb_image);
            File::delete($destinationPath.'/'.$data[0]->image);
        }else{
            $imageName = $data[0]->image;
        }

        Post::where('id', $request->id)->update([
            'type' => $request->type,
            'title' => $request->title,
            'slug' => $request->slug,
            'text' => $request->text,
            'thumb_image' => 'thumb_'.$imageName,
            'image' => $imageName
        ]);
        
        PostBillingual::where('id_post', $request->id)->update([
            'title' => $request->titleBilingual,
            'text' => $request->textBilingual,
        ]);
        
        return response()->json([
            'status' => true,
            'message' => 'Data Post berhasil diupdate',
        ], 200);
    }

    //delete data
    public function deleteData(Request $request) {
        $data = Post::where('id', $request->id)->get();

        $pathThumbImage = public_path('/storage/post/thumb_images');
        $pathImage = public_path('/storage/post/images');
        File::delete($pathThumbImage.'/'.$data[0]->thumb_image);
        File::delete($pathImage.'/'.$data[0]->image);

        Post::where('id', $request->id)->delete();
        PostBillingual::where('id_post', $request->id)->delete();

        return response()->json([
            'status' => true,
            'message' => 'Data post berhasil dihapus'
        ], 200);
    }
}
