<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Album;
use App\Models\Photo;
use Illuminate\Support\Facades\File;
use Image;

class PhotoController extends Controller
{
    //get all data foto
    public function getAllData()
    {
        $data = Photo::all();
        $totalData = Photo::count();

        return response()->json([
            'status' => true,
            'message' => 'Data foto berhasil didapatkan',
            'totalData' => $totalData,
            'data' => $data
        ], 200);
    }

    //select data by id
    public function selectDataById(Request $request) {
        $data = Photo::where('id', $request->id)->get();

        return response()->json([
            'status' => true,
            'message' => 'Data foto berhasil didapatkan',
            'data' => $data
        ], 200);
    }

    //select data by album
    public function selectDataByAlbum(Request $request) {
        $query = Photo::where('id_album', $request->idAlbum);
        $data = $query->get();
        $totalData = $query->count();
        $dataAlbum = Album::where('id', $request->idAlbum)->get();

        return response()->json([
            'status' => true,
            'message' => 'Data foto berhasil didapatkan',
            'totalData' => $totalData,
            'dataAlbum' => $dataAlbum,
            'data' => $data
        ], 200);
    }

    //store data
    public function storeData(Request $request) {
        $validateImage = $this->validate($request, [
            'image' => 'required|image|mimes:jpg,png,jpeg,webp|max:2048',
        ], [
            'image.image' => 'File haru berupa gambar',
            'image.mimes' => 'File Gambar harus bertipe jpg, png, jpeg, atau webp',
            'image.max' => 'File gambar yang di upload maksimal 2 MB'
        ]);

        $image = $request->file('image');
        $imageName = time().'.'.$image->extension();
        $thumbPath = public_path('/storage/photo/thumb_images');
        $destinationPath = public_path('/storage/photo/images');
        $img = Image::make($image->path());
        $thumbImage = $img->resize(400, 400, function($constraint) {
            $constraint->aspectRatio();
        })->save($thumbPath.'/thumb_'.$imageName);
        $mainImage = $image->move($destinationPath, $imageName);

        Photo::create([
            'title' => $request->title,
            'thumb_image' => 'thumb_'.$imageName,
            'image' => $imageName,
            'id_album' => $request->idAlbum
        ]);

        $queryAlbum = Album::where('id', $request->idAlbum);
        $dataAlbum = $queryAlbum->get();
        $totalFotoAlbum = $dataAlbum[0]->total_image + 1;
        $queryAlbum->update(['total_image' => $totalFotoAlbum]);

        return response()->json([
            'status' => true,
            'message' => 'Data foto berhasil disimpan'
        ], 200);
    }

    //update data
    public function updateData(Request $request) {
        Photo::where('id', $request->id)
            ->update([
                'title' => $request->title,
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Data foto berhasil diupdate'
        ], 200);
    }

    //delete data
    public function deleteData(Request $request) {
        $queryFoto = Photo::where('id', $request->id);
        $dataFoto = $queryFoto->get();

        $queryAlbum = Album::where('id', $dataFoto[0]->id_album);
        $dataAlbum = $queryAlbum->get();
        $setTotalFotoAlbum = $dataAlbum[0]->total_image - 1;

        //update total foto album
        $queryAlbum->update(['total_image' => $setTotalFotoAlbum]);

        //delete foto
        $thumbPath = public_path('/storage/photo/thumb_images');
        $destinationPath = public_path('/storage/photo/images');

        File::delete($thumbPath.'/'.$dataFoto[0]->thumb_image);
        File::delete($destinationPath.'/'.$dataFoto[0]->image);

        //delete foto from db
        $queryFoto->delete();

        return response()->json([
            'status' => true,
            'message' => 'Data foto berhasil dihapus',
        ], 200);
    }

}
