<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Album;
use App\Models\AlbumBillingual;
use App\Models\Photo;
use App\Models\PhotoBillingual;
use Illuminate\Support\Facades\File;
use Image;

class PhotoBillingualController extends Controller
{
    //select data by album
    public function selectDataByAlbum(Request $request) {
        $dataArray = array();
        $dataPhotos = Photo::where('id_album', $request->idAlbum)->orderByDesc('id')->get();
        $dataAlbum = Album::where('id', $request->idAlbum)->first();
        $dataAlbumBilingual = AlbumBillingual::where('id_album', $request->idAlbum)->first();

        foreach($dataPhotos as $dataPhoto) {
            $dataPhotoBilingual = PhotoBillingual::where('id_photo', $dataPhoto->id)->first();

            array_push($dataArray, (object) [
                'dataPhoto' => $dataPhoto,
                'dataPhotoBillingual' => $dataPhotoBilingual,
            ]);
        }

        return response()->json([
            'status' => true,
            'message' => 'Data foto berhasil didapatkan',
            'dataPhotos' => $dataArray,
            'dataAlbum' => $dataAlbum,
            'dataAlbumBillingual' => $dataAlbumBilingual,
        ], 200);
    }

    //select data by id
    public function selectDataById(Request $request) {
        $dataPhoto = Photo::where('id', $request->id)->first();
        $dataPhotoBilingual = PhotoBillingual::where('id_photo', $request->id)->first();
        
        return response()->json([
            'status' => true,
            'message' => 'Data foto berhasil didapatkan',
            'dataPhoto' => $dataPhoto,
            'dataPhotoBillingual' => $dataPhotoBilingual
        ]);
    }

    //store data
    public function storeData(Request $request) {
        $validateImage = $this->validate($request, [
            'image' => 'required|image|mimes:jpg,png,jpeg|max:1024',
        ]);

        $image = $request->file('image');
        $imageName = time().'.'.$image->extension();
        $thumbPath = public_path('/storage/photo/thumb_images');
        $destinationPath = public_path('/storage/photo/images');
        $img = Image::make($image->path());
        $thumbImage = $img->resize(600, 600, function($constraint) {
            $constraint->aspectRatio();
        })->save($thumbPath.'/thumb_'.$imageName);
        $mainImage = $image->move($destinationPath, $imageName);

        $storePhoto = Photo::create([
            'title' => $request->title,
            'thumb_image' => 'thumb_'.$imageName,
            'image' => $imageName,
            'id_album' => $request->idAlbum
        ]);

        PhotoBillingual::create([
            'title' => $request->titleBilingual,
            'id_photo' => $storePhoto->id
        ]);

        $queryAlbum = Album::where('id', $request->idAlbum);
        $dataAlbum = $queryAlbum->get();
        $totalFotoAlbum = $dataAlbum[0]->total_image + 1;
        $queryAlbum->update(['total_image' => $totalFotoAlbum]);

        return response()->json([
            'status' => true,
            'message' => 'Data foto berhasil disimpan'
        ], 200);
    }

    //update data
    public function updateData(Request $request) {
        Photo::where('id', $request->id)
            ->update([
                'title' => $request->title,
        ]);

        PhotoBillingual::where('id_photo', $request->id)
            ->update([
                'title' => $request->titleBilingual
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Data foto berhasil diupdate'
        ], 200);
    }

    //delete data
    public function deleteData(Request $request) {
        $queryFoto = Photo::where('id', $request->id);
        $dataFoto = $queryFoto->get();

        $queryAlbum = Album::where('id', $dataFoto[0]->id_album);
        $dataAlbum = $queryAlbum->get();
        $setTotalFotoAlbum = $dataAlbum[0]->total_image - 1;

        //update total foto album
        $queryAlbum->update(['total_image' => $setTotalFotoAlbum]);

        //delete foto
        $thumbPath = public_path('/storage/photo/thumb_images');
        $destinationPath = public_path('/storage/photo/images');

        File::delete($thumbPath.'/'.$dataFoto[0]->thumb_image);
        File::delete($destinationPath.'/'.$dataFoto[0]->image);

        //delete foto from db
        $queryFoto->delete();
        PhotoBillingual::where('id_photo', $request->id)->delete();

        return response()->json([
            'status' => true,
            'message' => 'Data foto berhasil dihapus',
        ], 200);
    }
}
