<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Page;
use Illuminate\Support\Facades\File;
use Image;

class PageController extends Controller
{
    //get all data
    public function getAllData() {
        $data = Page::all();

        return response()->json([
            'status' => true,
            'message' => 'Data page berhasil didapatkan',
            'data' => $data
        ], 200);
    }

    //select data by id
    public function selectDataById(Request $request) {
        $data = Page::where('id', $request->id)->get();

        return response()->json([
            'status' => true,
            'message' => 'Data page berhsil didapatkan',
            'data' => $data
        ], 200);
    }

    //select data by slug
    public function selectDataBySlug(Request $request) {
        $data = Page::where('slug', $request->slug)->get();

        return response()->json([
            'status' => true,
            'message' => 'Data page berhasil didapatkan',
            'data' => $data
        ], 200);
    }

    //store data
    public function storeData(Request $request) {
        if($request->hasFile('image')){
            $validateImage = $this->validate($request, [
                'image' => 'required|image|mimes:jpg,png,jpeg,webp|max:2048',
            ], [
                'image.image' => 'File haru berupa gambar',
                'image.mimes' => 'File Gambar harus bertipe jpg, png, jpeg, atau webp',
                'image.max' => 'File gambar yang di upload maksimal 2 MB'
            ]);


            $image = $request->file('image');
            $imageName = time().'.'.$image->extension();
            $thumbPath = public_path('/storage/page/thumb_images');
            $destinationPath = public_path('/storage/page/images');
            $img = Image::make($image->path());
            $thumbImage = $img->resize(400, 400, function($constraint) {
                $constraint->aspectRatio();
            })->save($thumbPath.'/thumb_'.$imageName);
            $mainImage = $image->move($destinationPath, $imageName);
        }else{
            $imageName = 'no-image';
        }

        Page::create([
            'name' => $request->name,
            'title' => $request->title,
            'slug' => $request->slug,
            'text' => $request->text,
            'thumb_image' => 'thumb_'.$imageName,
            'image' => $imageName
        ]);     

        return response()->json([
            'status' => true,
            'message' => 'Data page berhasil disimpan'
        ], 200);
    }

    //update data
    public function updateData(Request $request) {
        $data = Page::where('id', $request->id)->get();

        if($request->hasFile('image')){
            $validateImage = $this->validate($request, [
                'image' => 'required|image|mimes:jpg,png,jpeg,webp|max:2048',
            ], [
                'image.image' => 'File haru berupa gambar',
                'image.mimes' => 'File Gambar harus bertipe jpg, png, jpeg, atau webp',
                'image.max' => 'File gambar yang di upload maksimal 2 MB'
            ]);

    
            if(!$validateImage){
                return response()->json([
                    'status' => false,
                    'message' => 'Gambar gagal diupload'
                ], 200);
            }

            $image = $request->file('image');
            $imageName = time().'.'.$image->extension();
            $thumbPath = public_path('/storage/page/thumb_images');
            $destinationPath = public_path('/storage/page/images');
            $img = Image::make($image->path());

            $thumbImage = $img->resize(400, 400, function($constraint) {
                $constraint->aspectRatio();
            })->save($thumbPath.'/thumb_'.$imageName);

            $mainImage = $image->move($destinationPath, $imageName);

            File::delete($thumbPath.'/'.$data[0]->thumb_image);
            File::delete($destinationPath.'/'.$data[0]->image);
        }else{
            $imageName = $data[0]->image;
        }

        Page::where('id', $request->id)
            ->update([
                'name' => $request->name,
                'title' => $request->title,
                'slug' => $request->slug,
                'text' => $request->text,
                'thumb_image' => 'thumb_'.$imageName,
                'image' => $imageName
            ]);

        return response()->json([
            'status' => true,
            'message' => 'Data Page berhasil diupdate'
        ], 200);
    }
}
