<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Image;
use App\Models\Page;
use App\Models\PageBillingual;

class PageBillingualController extends Controller
{
    //get all data
    public function getAllData() {
        $queryDataPage = Page::orderByDesc('id');
        $dataPages = $queryDataPage->get();
        $countDataPage = $queryDataPage->count();

        $dataArray = array();
        foreach($dataPages as $dataPage) {
            $dataPageBillingual = PageBillingual::where('id_page', $dataPage->id)->first();
            array_push($dataArray, (object)[
                'dataPage' => $dataPage,
                'dataPageBillingual' => $dataPageBillingual
            ]);
        } 

        return response()->json([
            'status' => true,
            'totalData' => $countDataPage,
            'data' => $dataArray
        ], 200);
    }

    //select data by id
    public function selectDataById(Request $request) {
        $queryDataPages = Page::where('id', $request->id);
        $dataPages = $queryDataPages->get();

        $dataArray = array();
        foreach($dataPages as $dataPage) {
            $dataPageBillingual = PageBillingual::where('id_page', $dataPage->id)->first();
            array_push($dataArray, (object)[
                'dataPage' => $dataPage,
                'dataPageBillingual' => $dataPageBillingual
            ]);
        } 

        return response()->json([
            'status' => true,
            'data' => $dataArray
        ], 200);
    }

    //select data by slug
    public function selectDataBySlug(Request $request) {
        $queryDataPages = Page::where('slug', $request->slug);
        $dataPages = $queryDataPages->get();

        $dataArray = array();
        foreach($dataPages as $dataPage) {
            $dataPageBillingual = PageBillingual::where('id_page', $dataPage->id)->first();
            array_push($dataArray, (object)[
                'dataPage' => $dataPage,
                'dataPageBillingual' => $dataPageBillingual
            ]);
        } 

        return response()->json([
            'status' => true,
            'data' => $dataArray
        ], 200);
    }

    //update data
    public function updateData(Request $request) {
        $data = Page::where('id', $request->id)->get();

        if($request->hasFile('image')){
            $validateImage = $this->validate($request, [
                'image' => 'required|image|mimes:jpg,png,jpeg|max:1048',
            ]);
    
            if(!$validateImage){
                return response()->json([
                    'status' => false,
                    'message' => 'Gambar gagal diupload'
                ], 200);
            }

            $image = $request->file('image');
            $imageName = time().'.'.$image->extension();
            $thumbPath = public_path('/storage/page/thumb_images');
            $destinationPath = public_path('/storage/page/images');
            $img = Image::make($image->path());

            $thumbImage = $img->resize(600, 600, function($constraint) {
                $constraint->aspectRatio();
            })->save($thumbPath.'/thumb_'.$imageName);

            $mainImage = $image->move($destinationPath, $imageName);

            File::delete($thumbPath.'/'.$data[0]->thumb_image);
            File::delete($destinationPath.'/'.$data[0]->image);
        }else{
            $imageName = $data[0]->image;
        }

        Page::where('id', $request->id)
            ->update([
                'name' => $request->name,
                'title' => $request->title,
                'slug' => $request->slug,
                'text' => $request->text,
                'thumb_image' => 'thumb_'.$imageName,
                'image' => $imageName
            ]);
        
        PageBillingual::where('id_page', $request->id)
            ->update([
                'title' => $request->titleBilingual,
                'text' => $request->textBilingual,
            ]);

        return response()->json([
            'status' => true,
            'message' => 'Data Page berhasil diupdate'
        ], 200);
    }
}
