<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Pagination\LengthAwarePaginator;
use App\Models\MessageVisitor;

class MessageVisitorController extends Controller
{
    //get all data
    public function getAllData() {
        $dataMessageVisitor = MessageVisitor::orderByDesc('id')->get();

        return response()->json([
            'status' => true,
            'message' => 'Data pesan pengunjung berhasil didiapatkan',
            'data' => $dataMessageVisitor
        ], 200);
    }

    //get all data with pagination
    public function getAllDataWithPagination(Request $request) {
        $dataArray = array();
        $queryDataMessageVisitors = MessageVisitor::orderByDesc('id');
        $dataMessageVisitors = $queryDataMessageVisitors->get();
        $totalDataMessageVisitor = $queryDataMessageVisitors->count();

        foreach($dataMessageVisitors as $dataMessageVisitor) {
            array_push($dataArray, $dataMessageVisitor);
        }

        $perPage = 20;
        $currentPage = $request->currentPage;
        $offset = ($currentPage * $perPage) - $perPage;
        $dataToShow = array_slice($dataArray, $offset, $perPage);
        
        $dataArrayPaginate = new LengthAwarePaginator($dataToShow, $totalDataMessageVisitor, $perPage);

        return response()->json([
            'status' => true,
            'data' => $dataArrayPaginate
        ], 200);
    }

    //select data by id
    public function selectDataById(Request $request) {
        $dataMessageVisitor = MessageVisitor::where('id', $request->id)->first();

        return response()->json([
            'status' => true,
            'message' => 'Data pesan pengunjung berhasil didiapatkan',
            'data' => $dataMessageVisitor
        ], 200);
    }

    //store data
    public function storeData(Request $request) {
        MessageVisitor::create([
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'company' => $request->company,
            'position' => $request->position,
            'address' => $request->address,
            'message' => $request->message
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Pesan berhasil dikirim.'
        ], 200);
    }

    public function deleteData(Request $request) {
        MessageVisitor::where('id', $request->id)->delete();

        return response()->json([
            'status' => true,
            'message' => 'Data pesan pengunjung berhasil di hapus'
        ], 200);
    }
}
