<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;

class LoginController extends Controller
{
    //Login API
    public function login(Request $request)
    {

        $auth = $request->only('username', 'password');

        if(!Auth::attempt($auth)){
            return response()->json([
                'status' => false,
                'message' => 'username atau password salah',
            ], 200);
        }

        $token = Auth::user()->createToken($request->username)->plainTextToken;
        $data = User::where('username', $request->username)->get();

        return response()->json([
            'status' => true,
            'message' => 'Login berhasil',
            'data' => $data,
            'token' => $token
        ], 200);
        
    }

    //logout API
    public function logout()
    {
        Auth::user()->currentAccessToken()->delete();
        return response()->json([
            'status' => 'true',
            'message' => 'Anda telah logout'
        ]);
    }
}
