<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Document;
use Illuminate\Support\Facades\File;

class DocumentController extends Controller
{
    public function getAllData() {
        $data = Document::all();
        $totalData = Document::count();

        return response()->json([
            'status' => true,
            'message' => 'Data kategori dokumen berhasil didapatkan',
            'totalData' => $totalData,
            'data' => $data
        ], 200);
    }

    // get all data with pagination
    public function getAllDataWithPagination(Request $request) {
        $search = $request->search;
        $category = $request->idCategory;
        $type = $request->type;
        
        if ($category) {
            $query = Document::join('category_documents', 'documents.id_category', '=', 'category_documents.id')
                ->where('documents.title', 'LIKE', '%'.$search.'%')
                ->where('documents.id_category', '=', $category)
                ->where('documents.type', '=', $type)
                ->orderByDesc('id');
        } else {
            $query = Document::join('category_documents', 'documents.id_category', '=', 'category_documents.id')
                ->where('documents.title', 'LIKE', '%'.$search.'%')
                ->where('documents.type', '=', $type)
                ->orderByDesc('id');
        }

        $totalData = $query->count();
        $data = $query->select([
            'documents.id',
            'documents.id_category',
            'category_documents.name as category',
            'documents.title',
            'documents.document',
            'documents.created_at',
            'documents.updated_at'
        ])->paginate(50);

        return response()->json([
            'status' => true,
            'message' => 'Data dokumen berhasil didapatkan',
            'totalData' => $totalData,
            'data' => $data
        ], 200);
    }

    //select data by id
    public function selectDataById(Request $request) {
        $data = Document::where('id', $request->id)->get();

        return response()->json([
            'status' => true,
            'message' => 'Data dokument berhasil didapatkan',
            'data' => $data
        ]);
    }

    //store data
    public function storeData(Request $request) {
        $validateFile = $this->validate($request, [
            'file' => 'required|mimes:csv,txt,xlx,xls,pdf,ppt,pptx,docx,doc',
        ], [
            'file.mimes' => 'Tipe dokumen yang harus di upload berupa : csv, txt, xlx, pdf, ppt, docx, dan doc'
        ]);

        $file = $request->file('file');
        $fileName = time().'.'.$file->extension();
        $destinationPath = public_path('/storage/document');
        $mainFile = $file->move($destinationPath, $fileName);

        Document::create([
            'id_category' => $request->idCategory,
            'type' => $request->type,
            'title' => $request->title,
            'document' => $fileName
        ]);        

        return response()->json([
            'status' => true,
            'message' => 'Data dokumen berhasil disimpan'
        ], 200);
    }

    //update data
    public function updateData(Request $request) {
        $data = Document::where('id', $request->id)->get();

        if($request->hasFile('file')){
            $validateFile = $this->validate($request, [
                'file' => 'required|mimes:csv,txt,xlx,xls,pdf,ppt,pptx,docx,doc',
            ], [
                'file.mimes' => 'Tipe dokumen yang harus di upload berupa : csv, txt, xlx, pdf, ppt, docx, dan doc'
            ]);

            $file = $request->file('file');
            $fileName = time().'.'.$file->extension();
            $destinationPath = public_path('/storage/document');
            $mainFile = $file->move($destinationPath, $fileName);

            File::delete($destinationPath.'/'.$data[0]->document);
        }else{
            $fileName = $data[0]->document;
        }

        Document::where('id', $request->id)
            ->update([
                'id_category' => $request->idCategory,
                'type' => $request->type,
                'title' => $request->title,
                'document' => $fileName
            ]);

        return response()->json([
            'status' => true,
            'message' => 'Data dokumen berhasil diupdate'
        ], 200);
    }

    //delete data
    public function deleteData(Request $request) {
        $data = Document::where('id', $request->id)->get();

        $pathFile = public_path('/storage/document');
        File::delete($pathFile.'/'.$data[0]->document);

        Document::where('id', $request->id)->delete();

        return response()->json([
            'status' => true,
            'message' => 'Data dokumen berhasil dihapus'
        ], 200);
    }
}
