<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Division;
use App\Models\DivisionBillingual;
use Illuminate\Support\Arr;

class DivisionBillingualController extends Controller
{
    //get all data
    public function getAllData() {
        $dataArray = array();
        $queryDataDivision = Division::orderBy('highlight', 'asc');
        $dataDivisions = $queryDataDivision->get();
        $countDataDivision = $queryDataDivision->count();

        foreach($dataDivisions as $dataDivision) {
            $dataDivisionBillingual = DivisionBillingual::where('id_division', $dataDivision->id)->first();
            array_push($dataArray, (object)[
                'dataDivision' => $dataDivision,
                'dataDivisionBillingual' => $dataDivisionBillingual
            ]);
        } 

        return response()->json([
            'status' => true,
            'totalData' => $countDataDivision,
            'data' => $dataArray
        ], 200);
    }

    //select data by id
    public function selectDataById(Request $request) {
        $dataArray = array();
        $queryDataDivisions = Division::where('id', $request->id);
        $dataDivisions = $queryDataDivisions->get();

        foreach($dataDivisions as $dataDivision) {
            $dataDivisionBillingual = DivisionBillingual::where('id_division', $dataDivision->id)->first();
            array_push($dataArray, (object)[
                'dataDivision' => $dataDivision,
                'dataDivisionBillingual' => $dataDivisionBillingual
            ]);
        } 

        return response()->json([
            'status' => true,
            'data' => $dataArray
        ], 200);
    }

    //store data
    public function storeData(Request $request) {
        $storeDivision = Division::create([
            'name' => $request->name,
            'slug' => $request->slug,
            'highlight' => $request->highlight
        ]);

        DivisionBillingual::create([
            'name' => $request->nameBilingual,
            'id_division' => $storeDivision->id
        ]);

        $dataArray = Array();
        array_push($dataArray, $request->name, $request->slug, $request->highlight);

        return response()->json([
            'status' => true,
            'message' => 'Data Divisi berhasil disimpan',
            'data' => $dataArray
        ], 200);
    }

    //update data
    public function updateData(Request $request) {
        Division::where('id', $request->id)
            ->update([
                'name' => $request->name,
                'slug' => $request->slug
            ]);

        DivisionBillingual::where('id_division', $request->id)
            ->update([
                'name' => $request->nameBilingual
            ]);

        $query = Division::where('id', $request->id);
        $highlightNew = $request->highlight;
        $dataOnUpdate = $query->first();
        
        return response()->json([
            'status' => true,
            'message' => 'Data Divisi berhasil diupdate',
        ], 200);
    }

    //update order
    public function updateOrder(Request $request) {
        $dataArrayId = array();
        $query = Division::where('id', $request->id);
        $dataOld = $query->first();
        $highlightOld = $dataOld->highlight;
        $highlightNew = intVal($request->highlight);

        if($highlightNew < $highlightOld) {
            for($i = $highlightNew; $i < $highlightOld; $i++) {
                $dataDivision = Division::where('highlight', $i)->first();
                array_push($dataArrayId, $dataDivision->id);
            }
            foreach($dataArrayId as $data) {
                $dataDivision = Division::where('id', $data)->first();
                $dataHighlight = $dataDivision->highlight;
                Division::where('id', $data)
                    ->update(['highlight' => $dataHighlight + 1]);
            }
            Division::where('id', $request->id)
                ->update(['highlight' => $highlightNew]);
        } else {
            for($i = $highlightOld; $i <= $highlightNew; $i++) {
                $dataDivision = Division::where('highlight', $i)->first();
                array_push($dataArrayId, $dataDivision->id);
            }
            foreach($dataArrayId as $data) {
                $dataDivision = Division::where('id', $data)->first();
                $dataHighlight = $dataDivision->highlight;
                Division::where('id', $data)
                    ->update(['highlight' => $dataHighlight - 1]);
            }
            Division::where('id', $request->id)
                ->update(['highlight' => $highlightNew]);
        }
    
        
        return response()->json([
            'status' => true,
            'message' => 'Data Divisi berhasil diupdate'
        ], 200);
    }

    //delete data
    public function deleteData(Request $request) {
        $totalData = Division::count();
        $dataDivisionDelete = Division::where('id', $request->id)->first();
        $dataHighlightDelete = $dataDivisionDelete->highlight;

        for($i = intval($dataHighlightDelete) + 1; $i <= $totalData; $i++) {
            $dataDivision = Division::where('highlight', $i)->first();
            Division::where('id', $dataDivision->id)
                ->update(['highlight' => $i - 1]);
        }

        Division::where('id', $request->id)->delete();
        DivisionBillingual::where('id_division', $request->id)->delete();

        return response()->json([
            'status' => true,
            'message' => 'Data Divisi berhasil dihapus',
        ], 200);
    }
}
