<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\CategoryDocument;

class CategoryDocumentController extends Controller
{
    //get all data
    public function getAllData() {
        $data = CategoryDocument::all();
        $totalData = CategoryDocument::count();

        return response()->json([
            'status' => true,
            'message' => 'Data kategori dokumen berhasil didapatkan',
            'totalData' => $totalData,
            'data' => $data
        ], 200);
    }

    //get data by type with pagination
    public function getAllDataWithPagination(Request $request) {
        $query = CategoryDocument::orderByDesc('id');
        $data = $query->paginate(50);
        $totalData = $query->count();

        return response()->json([
            'status' => true,
            'message' => 'Data kategori dokumen berhasil didapatkan',
            'totalData' => $totalData,
            'data' => $data
        ], 200);
    }

    //select data by id
    public function selectDataById(Request $request) {
        $data = CategoryDocument::where('id', $request->id)->first();

        return response()->json([
            'status' => true,
            'message' => 'Data kategori produk hukum berhasil didapatkan',
            'data' => $data
        ], 200);
    }

    //store data
    public function storeData(Request $request) {
        $storePost = CategoryDocument::create([
            'name' => $request->name,
        ]); 

        return response()->json([
            'status' => true,
            'message' => 'Data kategori produk hukum berhasil disimpan',
        ], 200);
    }
    
    //update data
    public function updateData(Request $request) {
        CategoryDocument::where('id', $request->id)->update([
            'name' => $request->name,
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Data kategori produk hukum berhasil diupdate',
        ], 200);
    }

    //delete data
    public function deleteData(Request $request) {
        CategoryDocument::where('id', $request->id)->delete();

        return response()->json([
            'status' => true,
            'message' => 'Data kategori produk hukum berhasil dihapus',
        ], 200);
    }
}
