<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\CategoryAgenda;

class CategoryAgendaController extends Controller
{
    //get all data
    public function getAllData() {
        $data = CategoryAgenda::all();
        $totalData = CategoryAgenda::count();

        return response()->json([
            'status' => true,
            'message' => 'Data kategori agenda berhasil didapatkan',
            'totalData' => $totalData,
            'data' => $data
        ], 200);
    }

    //get data by type with pagination
    public function getAllDataWithPagination(Request $request) {
        $query = CategoryAgenda::orderByDesc('id');
        $data = $query->paginate(50);
        $totalData = $query->count();

        return response()->json([
            'status' => true,
            'message' => 'Data kategori agenda berhasil didapatkan',
            'totalData' => $totalData,
            'data' => $data
        ], 200);
    }

    //select data by id
    public function selectDataById(Request $request) {
        $data = CategoryAgenda::where('id', $request->id)->first();

        return response()->json([
            'status' => true,
            'message' => 'Data kategori agenda berhasil didapatkan',
            'data' => $data
        ], 200);
    }

    //store data
    public function storeData(Request $request) {
        $storePost = CategoryAgenda::create([
            'name' => $request->name,
        ]); 

        return response()->json([
            'status' => true,
            'message' => 'Data kategori agenda berhasil disimpan',
        ], 200);
    }
    
    //update data
    public function updateData(Request $request) {
        CategoryAgenda::where('id', $request->id)->update([
            'name' => $request->name,
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Data kategori agenda berhasil diupdate',
        ], 200);
    }

    //delete data
    public function deleteData(Request $request) {
        CategoryAgenda::where('id', $request->id)->delete();

        return response()->json([
            'status' => true,
            'message' => 'Data kategori agenda berhasil dihapus',
        ], 200);
    }
}
