<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Album;
use App\Models\Photo;
use Illuminate\Support\Facades\File;

class AlbumController extends Controller
{
    //get all data album
    public function getAllData()
    {
        $dataAlbums = Album::orderByDesc('id')->get();
        $count = Album::count();

        $dataArray = array();
        foreach($dataAlbums as $dataAlbum) {
            $dataFoto = Photo::where('id_album', $dataAlbum->id)->orderByDesc('id')->get();
            array_push($dataArray, (object)[
                'dataAlbum' => $dataAlbum,
                'dataPhoto' => $dataFoto
            ]);
        }

        return response()->json([
            'status' => true,
            'message' => 'Data album berhasil didapatkan',
            'totalData' => $count,
            'data' => $dataArray
        ], 200);
    }

    //select data by id
    public function selectDataById(Request $request) {
        $data = Album::where('id', $request->id)->get();

        return response()->json([
            'status' => true,
            'message' => 'Data album berhasil didapatkan',
            'data' => $data
        ], 200);
    }

    //select data by slug
    public function selectDataBySlug(Request $request) {
        $dataAlbums = Album::where('slug', $request->slug)->get();

        $dataArray = array();
        foreach($dataAlbums as $dataAlbum) {
            $dataFoto = Photo::where('id_album', $dataAlbum->id)->get();
            array_push($dataArray, (object)[
                'dataAlbum' => $dataAlbum,
                'dataPhoto' => $dataFoto
            ]);
        }

        return response()->json([
            'status' => true,
            'message' => 'Data album berhasil didapatkan',
            'data' => $dataArray
        ], 200);
    }

    // store data album
    public function storeData(Request $request) {
        Album::create([
            'title' => $request->title,
            'slug' => $request->slug
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Data album berhasil disimpan'
        ], 200);
    }

    // update data album
    public function updateData(Request $request) {
        Album::where('id', $request->id)
            ->update([
                'title' => $request->title,
                'slug' => $request->slug,
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Data album berhasil diupdate'
        ], 200);
    }

    //delete album including it's photos
    public function deleteData(Request $request) {
        $queryAlbum = Album::where('id', $request->id);
        $queryFoto = Photo::where('id_album', $request->id);
        $dataFoto = $queryFoto->get();

        $thumbPath = public_path('/storage/photo/thumb_images');
        $destinationPath = public_path('/storage/photo/images');

        //delete file foto
        foreach($dataFoto as $data){
            File::delete($thumbPath.'/'.$data->thumb_image);
            File::delete($destinationPath.'/'.$data->image);
        }

        //delete data foto from database
        $queryFoto->delete();

        //delete data album from database
        $queryAlbum->delete();

        return response()->json([
            'status' => true,
            'message' => 'Data album berhasil dihapus',
        ], 200);
    }
}
