<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Pagination\LengthAwarePaginator;
use App\Models\Album;
use App\Models\AlbumBillingual;
use App\Models\Photo;
use App\Models\PhotoBillingual;

class AlbumBillingualController extends Controller
{
    //get all data
    public function getAllData() {
        $dataAlbums = Album::orderByDesc('id')->get();
        $count = Album::count();

        $dataArray = array();
        
        foreach($dataAlbums as $dataAlbum) {
            $dataArrayPhoto = array();

            $dataAlbumBilingual = AlbumBillingual::where('id_album', $dataAlbum->id)->first();
            $dataPhotos = Photo::where('id_album', $dataAlbum->id)->orderByDesc('id')->get();

            foreach($dataPhotos as $dataPhoto) {
                $dataPhotoBilingual = PhotoBillingual::where('id_photo', $dataPhoto->id)->first();
                array_push($dataArrayPhoto, (object)[
                    'dataPhoto' => $dataPhoto,
                    'dataPhotoBillingual' => $dataPhotoBilingual
                ]);
            }

            array_push($dataArray, (object) [
                'dataAlbum' => $dataAlbum,
                'dataAlbumBillingual' => $dataAlbumBilingual,
                'dataPhotos' => $dataArrayPhoto
            ]);
        }

        return response()->json([
            'status' => true,
            'message' => 'Data album berhasil didapatkan',
            'totalData' => $count,
            'data' => $dataArray
        ], 200);
    }

    //get all data with pagination
    public function getAllDataWithPagination(Request $request) {
        $dataArray = array();
        $queryDataAlbums = Album::orderByDesc('id');
        $dataAlbums = $queryDataAlbums->get();
        $totalDataAlbum = $queryDataAlbums->count();

        foreach($dataAlbums as $dataAlbum) {
            $dataArrayPhoto = array();

            $dataAlbumBilingual = AlbumBillingual::where('id_album', $dataAlbum->id)->first();
            $dataPhotos = Photo::where('id_album', $dataAlbum->id)->orderByDesc('id')->get();

            foreach($dataPhotos as $dataPhoto) {
                $dataPhotoBilingual = PhotoBillingual::where('id_photo', $dataPhoto->id)->first();
                array_push($dataArrayPhoto, (object)[
                    'dataPhoto' => $dataPhoto,
                    'dataPhotoBillingual' => $dataPhotoBilingual
                ]);
            }

            array_push($dataArray, (object) [
                'dataAlbum' => $dataAlbum,
                'dataAlbumBillingual' => $dataAlbumBilingual,
                'dataPhotos' => $dataArrayPhoto
            ]);
        }

        $perPage = 20;
        $currentPage = $request->currentPage;
        $offset = ($currentPage * $perPage) - $perPage;
        $dataToShow = array_slice($dataArray, $offset, $perPage);
        
        $dataArrayPaginate = new LengthAwarePaginator($dataToShow, $totalDataAlbum, $perPage);

        return response()->json([
            'status' => true,
            'data' => $dataArrayPaginate
        ], 200);
    }

    //select data by id
    public function selectDataById(Request $request) {
        $dataArray = array();
        $dataArrayPhoto = array();

        $dataAlbum = Album::where('id', $request->id)->first();
        $dataAlbumBilingual = AlbumBillingual::where('id_album', $request->id)->first();
        $dataPhotos = Photo::where('id_album', $dataAlbum->id)->get();

        foreach($dataPhotos as $dataPhoto) {
            $dataPhotoBilingual = PhotoBillingual::where('id_photo', $dataPhoto->id)->first();
            array_push($dataArrayPhoto, (object) [
                'dataPhoto' => $dataPhoto,
                'dataPhotoBillingual' => $dataPhotoBilingual
            ]);
        }

        array_push($dataArray, (object) [
            'dataAlbum' => $dataAlbum,
            'dataAlbumBillingual' => $dataAlbumBilingual,
            'dataPhotos' => $dataArrayPhoto
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Data album berhasil didapatkan',
            'data' => $dataArray
        ], 200);
    }

    //store data
    public function storeData(Request $request) {
        $storeAlbum = Album::create([
            'title' => $request->title,
            'slug' => $request->slug
        ]);

        AlbumBillingual::create([
            'title' => $request->titleBilingual,
            'id_album' => $storeAlbum->id
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Data album berhasil disimpan'
        ], 200);
    }

    //update data
    public function updateData(Request $request) {
        Album::where('id', $request->id)
            ->update([
                'title' => $request->title,
                'slug' => $request->slug
            ]);

        AlbumBillingual::where('id_album', $request->id)
            ->update([
                'title' => $request->titleBilingual
            ]);

        return response()->json([
            'status' => true,
            'message' => 'Data album berhasil diupdate'
        ], 200);
    }

    //delete album including it's photos
    public function deleteData(Request $request) {
        $queryPhoto = Photo::where('id_album', $request->id);

        $thumbPath = public_path('/storage/photo/thumb_images');
        $destinationPath = public_path('/storage/photo/images');

        $dataPhotos = $queryPhoto->get();

        //delete file photo
        foreach($dataPhotos as $dataPhoto){
            File::delete($thumbPath.'/'.$dataPhoto->thumb_image);
            File::delete($destinationPath.'/'.$dataPhoto->image);
            PhotoBillingual::where('id_photo', $dataPhoto->id);
        }

        //delete data photo from database
        $queryPhoto->delete();

        //delete data album & album bilingual from database
        Album::where('id', $request->id)->delete();
        AlbumBillingual::where('id_album', $request->id)->delete();

        return response()->json([
            'status' => true,
            'message' => 'Data album berhasil dihapus',
        ], 200);
    }

}
