<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Agenda;
use Illuminate\Support\Facades\File;
use Illuminate\Pagination\LengthAwarePaginator;
use Image;

class AgendaController extends Controller
{
    //get all data
    public function getAllData() {
        $query = Agenda::join('category_agendas', 'agendas.id_category', '=', 'category_agendas.id')->orderByDesc('id');

        $totalData = $query->count();
        $data = $query->select([
            'agendas.id',
            'agendas.id_category',
            'category_agendas.name as category_name',
            'agendas.title',
            'agendas.slug',
            'agendas.date_start',
            'agendas.date_end',
            'agendas.text',
            'agendas.created_at',
            'agendas.updated_at'
        ])->get();

        return response()->json([
            'status' => true,
            'message' => 'Data agenda berhasil didapatkan',
            'totalData' => $totalData,
            'data' => $data
        ], 200);
    }

    // select data with pagination
    public function getAllDataWithPagination(Request $request) {
        $query = Agenda::join('category_agendas', 'agendas.id_category', '=', 'category_agendas.id')->orderByDesc('id');

        $totalData = $query->count();
        $data = $query->select([
            'agendas.id',
            'agendas.id_category',
            'category_agendas.name as category_name',
            'agendas.title',
            'agendas.slug',
            'agendas.date_start',
            'agendas.date_end',
            'agendas.text',
            'agendas.created_at',
            'agendas.updated_at'
        ])->paginate(50);

        return response()->json([
            'status' => true,
            'message' => 'Data agenda berhasil didapatkan',
            'totalData' => $totalData,
            'data' => $data
        ], 200);
    }

    //select latest 3 agenda
    public function selectThreeDataLatest() {
        $query = Agenda::join('category_agendas', 'agendas.id_category', '=', 'category_agendas.id')->orderByDesc('id');

        $totalData = $query->count();
        $data = $query->select([
            'agendas.id',
            'agendas.id_category',
            'category_agendas.name as category_name',
            'agendas.title',
            'agendas.slug',
            'agendas.date_start',
            'agendas.date_end',
            'agendas.text',
            'agendas.created_at',
            'agendas.updated_at'
        ])->limit(3)->get();

        return response()->json([
            'status' => true,
            'message' => 'Data agenda berhasil didapatkan',
            'totalData' => $totalData,
            'data' => $data
        ], 200);
    }

    //select data by id
    public function selectDataById(Request $request) {
        $data = Agenda::where('id', $request->id)->get();

        return response()->json([
            'status' => true,
            'message' => 'Data agenda berhasil didapatkan',
            'data' => $data
        ], 200);
    }

    //select data by slug
    public function selectDataBySlug(Request $request) {
        $query = Agenda::join('category_agendas', 'agendas.id_category', '=', 'category_agendas.id')
                ->where('agendas.slug', $request->slug);

        $totalData = $query->count();
        $data = $query->select([
            'agendas.id',
            'agendas.id_category',
            'category_agendas.name as category_name',
            'agendas.title',
            'agendas.slug',
            'agendas.date_start',
            'agendas.date_end',
            'agendas.text',
            'agendas.created_at',
            'agendas.updated_at'
        ])->first();

        return response()->json([
            'status' => true,
            'message' => 'Data agenda berhasil didapatkan',
            'data' => $data
        ], 200);
    }

    //store data
    public function storeData(Request $request) {
        if($request->hasFile('image')){
            $validateImage = $this->validate($request, [
                'image' => 'required|image|mimes:jpg,png,jpeg,webp|max:2048',
            ], [
                'image.image' => 'File haru berupa gambar',
                'image.mimes' => 'File Gambar harus bertipe jpg, png, jpeg, atau webp',
                'image.max' => 'File gambar yang di upload maksimal 2 MB'
            ]);

            $image = $request->file('image');
            $imageName = time().'.'.$image->extension();
            $thumbPath = public_path('/storage/agenda/thumb_images');
            $destinationPath = public_path('/storage/agenda/images');
            $img = Image::make($image->path());
            $thumbImage = $img->resize(400, 400, function($constraint) {
                $constraint->aspectRatio();
            })->save($thumbPath.'/thumb_'.$imageName);
            $mainImage = $image->move($destinationPath, $imageName);
        }else{
            $imageName = 'no-image';
        }

        Agenda::create([
            'id_category' => $request->idCategory,
            'title' => $request->title,
            'slug' => $request->slug,
            'date_start' => $request->dateStart,
            'date_end' => $request->dateEnd,
            'text' => $request->text,
            'thumb_image' => 'thumb_'.$imageName,
            'image' => $imageName
        ]);        

        return response()->json([
            'status' => true,
            'message' => 'Data agenda berhasil disimpan'
        ], 200);
    }

    //update data
    public function updateData(Request $request) {
        $data = Agenda::where('id', $request->id)->get();

        if($request->hasFile('image')){
            $validateImage = $this->validate($request, [
                'image' => 'required|image|mimes:jpg,png,jpeg,webp|max:2048',
            ], [
                'image.image' => 'File haru berupa gambar',
                'image.mimes' => 'File Gambar harus bertipe jpg, png, jpeg, atau webp',
                'image.max' => 'File gambar yang di upload maksimal 2 MB'
            ]);
    
            if(!$validateImage){
                return response()->json([
                    'status' => false,
                    'message' => 'Gambar gagal diupload'
                ], 200);
            }

            $image = $request->file('image');
            $imageName = time().'.'.$image->extension();
            $thumbPath = public_path('/storage/agenda/thumb_images');
            $destinationPath = public_path('/storage/agenda/images');
            $img = Image::make($image->path());

            $thumbImage = $img->resize(400, 400, function($constraint) {
                $constraint->aspectRatio();
            })->save($thumbPath.'/thumb_'.$imageName);

            $mainImage = $image->move($destinationPath, $imageName);

            File::delete($thumbPath.'/'.$data[0]->thumb_image);
            File::delete($destinationPath.'/'.$data[0]->image);
        }else{
            $imageName = $data[0]->image;
        }

        Agenda::where('id', $request->id)
            ->update([
                'id_category' => $request->idCategory,
                'title' => $request->title,
                'slug' => $request->slug,
                'date_start' => $request->dateStart,
                'date_end' => $request->dateEnd,
                'text' => $request->text,
                'thumb_image' => 'thumb_'.$imageName,
                'image' => $imageName
            ]);

        return response()->json([
            'status' => true,
            'message' => 'Data agenda berhasil diupdate'
        ], 200);
    }

    //delete data
    public function deleteData(Request $request) {
        $data = Agenda::where('id', $request->id)->get();

        $pathThumbImage = public_path('/storage/agenda/thumb_images');
        $pathImage = public_path('/storage/agenda/images');
        File::delete($pathThumbImage.'/'.$data[0]->thumb_image);
        File::delete($pathImage.'/'.$data[0]->image);

        Agenda::where('id', $request->id)->delete();

        return response()->json([
            'status' => true,
            'message' => 'Data agenda berhasil dihapus'
        ], 200);
    }
}
